#include <iostream>
#include <vector>
#include <unordered_map>

using namespace std;

#define MAX 1000000000

typedef long long ll;

int main(){
  ios_base::sync_with_stdio(false), cin.tie(0);
  
  int n; cin>>n;
  vector<pair<int, int>> vec(n);
  unordered_map<int, int> xCtrEven, xCtrOdd, yCtrEven, yCtrOdd, diagonal;

  ll res = 0;

  for (int i = 0; i < n; ++i){
    cin>>vec[i].first>>vec[i].second;

    int x = vec[i].first, y = vec[i].second;

    if (x % 2)
      ++xCtrOdd[x];
    else
      ++xCtrEven[x];

    if (y % 2)
      ++yCtrOdd[y];
    else
      ++yCtrEven[y];

    ++diagonal[x - y];
  }

  for (auto p: vec){
    --diagonal[p.first - p.second];
    res += diagonal[p.first - p.second] * 2;

    if (p.first % 2){
      --xCtrOdd[p.first];
      res += xCtrOdd[p.first];
    }
    else{
      --xCtrEven[p.first];
      res += xCtrEven[p.first];
    } 

    if (p.second % 2){
      --yCtrOdd[p.second];
      res += yCtrOdd[p.second];
    }
    else{
      --yCtrEven[p.second];
      res += yCtrEven[p.second];
    }
  }

  cout<<res;

  return 0;
}